var global = {};

var api = (function() {

	return {
		point: function () {
			var s = {
				x: false,
				y: false,
				id: false,
				dom: false
			}

			var r = {
				create: function (p) {
					s.x = p.x;
					s.y = p.y;
					s.id = 'id_' + new Date().getTime();

					var elem = document.createElement('div');
					elem.id = s.id;
					elem.className = 'point';
					elem.style.top = s.y + 'px';
					elem.style.left = s.x + 'px';

					s.dom =elem;

					global.body.appendChild(elem);

					return this;
				},
				getData: function() {
					return s;
				}
			}

			return r;
		},
		obj: function () {

			var s = {
				move: function() {
					var timeUpdate = 40;

					var makeMove = function makeMove() {
						if (r.life <= 0) {
							s = null;
							return false;
						}

						if (r.role === 'shot' || r.role === 'asteroid') {
							if (r.point.x < -100 || r.point.y < -100 || r.point.x > parseInt(document.body.clientWidth)+100 || r.point.y > parseInt(document.body.clientHeight)+100 ) {
								r.life = 0;
							}
						}

						if (r.alertCount !==0) {
							r.alertCount--;
							r.moveCount = 0;
						}

						if (r.moveCount !==0) {
							r.moveCount--;
						}

						r.point.x += r.speed.dx;
						r.point.y += r.speed.dy;

						r.point.dom.style.top = r.point.y + 'px';
						r.point.dom.style.left = r.point.x + 'px';

						if (r.role !== 'shot') {
							s.checkOnXplosion();
						}

						setTimeout(function() {
							makeMove();
						}, timeUpdate)

					}()
				},
				checkOnXplosion: function() {

					if (global.end) return false;

					for (var key in global.objects) {
						var currentObject = global.objects[key];

						if (r.life > 0) {
							if ((currentObject.id !== r.id) && (currentObject.life > 0)) {
								var sqDistance = Math.sqrt( (currentObject.point.x - r.point.x)*(currentObject.point.x - r.point.x) + (currentObject.point.y - r.point.y)*(currentObject.point.y - r.point.y) );

								if (sqDistance < (r.size + currentObject.size)) {

									currentObject.reduceLife(r.power, false);

									if (currentObject.author == 'user')
										r.reduceLife(currentObject.power, true);
									else
										r.reduceLife(currentObject.power, false);

								}

								if (r.role === 'enemy') {

									var shootTry = Math.random();
									var size = r.size + currentObject.size;
									var currentObjectK = currentObject.speed.dy / (currentObject.speed.dx+1);
									var U = ( currentObjectK * (r.point.x - currentObject.point.x) ) + currentObject.point.y;

									if (shootTry < 0.001) {
										global.shots.push(api.obj()
														.create({
															x: r.point.x - r.size - 1,
															y: r.point.y,
															life: 1,
															role: 'shot',
															cls: 'shot_enemy',
															power: 1,
															size: 0,
															speed: {
																dx: -5,
																dy: 0
															}
														}))
									}

									if ( sqDistance < 400 ) {

										if ( Math.abs(U-r.point.y) > (r.size + currentObject.size) ) {
											continue;
										}

										var randomAngle = Math.random() - 0.5;
										randomAngle = randomAngle/Math.abs(randomAngle);

										var randomAngleX = randomAngle;
										var randomAngleY = randomAngle;

										var screenHeight = document.body.clientHeight-50;
										var screenWidth = document.body.clientWidth-50;

										var dx = (currentObject.speed.dy/(Math.abs(currentObject.speed.dy)+1));
										var dy = (currentObject.speed.dx/(Math.abs(currentObject.speed.dx)+1));
										var candidateEndPointX = r.point.x + dx * randomAngleX * size * 2;
										var candidateEndPointY = r.point.y + dy * randomAngleY * size * 2;

										if (dx < 1 && dy < 1) {
											dx = Math.round((Math.random() * 2) - 1);
											dy = Math.round((Math.random() * 2) - 1);
										}

										if (candidateEndPointX < 50 || candidateEndPointX > screenWidth) {
											randomAngleX = randomAngleX * -1;
										}

										if (candidateEndPointY < 50 || candidateEndPointY > screenHeight) {
											randomAngleY = randomAngleY * -1;
										}

										if (!r.alertCount) {
											r.speed.dx = dx*randomAngleX*2;
											r.speed.dy = dy*randomAngleY*2;
											r.alertCount = size;
										}

									} else {
										if (!r.moveCount && !r.alertCount) {
											var verticalDistance = r.point.y - global.gamer.point.y;
											var dy = verticalDistance/(Math.abs(verticalDistance)+1) * -2;
											var dx = Math.round(Math.random() * 2) - 1;

											r.speed.dy = dy;
											r.speed.dx = dx;
											r.moveCount = 100;
										}
									}
								}
							}
						} else {
							delete global.objects[r.id];
						}
					}

				}
			}

			var r = {
				point: false,
				speed: false,
				role: false,
				author: false,
				size: 0,
				moveCount: 0,
				alertCount: 0,
				power: 1,
				create: function (p) {
					r.point = api.point()
								.create({
									x: p.x,
									y: p.y
								})
								.getData()

					r.id = r.point.id;
					r.life = p.life;
					r.speed = p.speed;
					r.role = p.role;
					r.size = p.size;
					r.point.dom.className += ' ' + p.cls;

					if (p.author !== undefined) {
						r.author = p.author;
					}
					if (p.power !== undefined) {
						r.power = p.power;
					}

					global.objects[r.id] = r;

					s.move();

					return this;
				},
				reduceLife: function(reducePower, isUserWeapon) {
					if (reducePower !== undefined) {
						r.life -= reducePower;
					} else {
						r.life--;
					}

					if (r.role === 'user') {
						global.life.style.width = r.life*10 + '%';
					}

					if ((isUserWeapon) && (r.role === 'enemy')) {
						var score = parseInt(global.score.innerHTML)
						global.score.innerHTML = score + 10;
					}

					if (r.life <= 0) {
						if (r.role === 'user') {
							global.end = true;
							delete global.objects;
							global.death.style.display = 'block';
							global.body.style.display = 'none';
						}

						if (r.role === 'enemy') {
							//alert('winner');
							if (isUserWeapon) {
								var score = parseInt(global.score.innerHTML)
								global.score.innerHTML = score + 100;
							}
						}

						global.body.removeChild( r.point.dom )
					}

					return this;
				},
				attachControls: function() {
					var vkey = '';
					var hkey = '';
					var controlLoop = function controlLoop () {

						if (vkey == 38) {
							if (r.point.y > 2)
								r.point.y -= 2;
						}

						if (hkey == 37) {
							if (r.point.x > 2)
								r.point.x -= 2;
						}

						if (vkey == 40) {
							r.point.y += 2;
						}

						if (hkey == 39) {
							r.point.x += 2;
						}

						setTimeout(function() {
							controlLoop();
						}, 40)
					}()

					document.addEventListener('keyup', function(e) {

						if (e.keyCode == 38 || e.keyCode == 40) {
							vkey = '';
						}

						if (e.keyCode == 37 || e.keyCode == 39) {
							hkey = '';
						}
					})

					document.addEventListener('keydown', function(e) {

						if (e.keyCode == 38 || e.keyCode == 40) {
							vkey = e.keyCode;
						}

						if (e.keyCode == 37 || e.keyCode == 39) {
							hkey = e.keyCode;
						}

						if (e.keyCode == 32) {

							if (global.end) return false;

							global.shots.push(api.obj()
											.create({
												x: global.gamer.point.x + global.gamer.size + 1,
												y: global.gamer.point.y,
												life: 1,
												power: 1,
												role: 'shot',
												author: 'user',
												cls: 'shot_user',
												size: 0,
												speed: {
													dx: 5,
													dy: 0
												}
											}))
						}
					})

					return this;

				}

			}

			return r;
		}
	};

})();

var enemies =[];


document.addEventListener('DOMContentLoaded', function() {

	global.body = document.querySelector('.wrapper');
	global.life = document.querySelector('.life .w');
	global.time = document.querySelector('.time');
	global.score = document.querySelector('.score');
	global.winner = document.querySelector('.winner');
	global.death = document.querySelector('.death');
	global.totalTime = 60;
	global.end = false;
	global.objects = {};
	global.shots = [];
	global.gamer = api.obj()
						.create({
							x: 200,
							y: 500,
							life: 10,
							role: 'user',
							cls: 'user',
							power: 2,
							size: 20,
							speed: {
								dx: 0,
								dy: 0
							}
						})
						.attachControls();

	setInterval(function() {

		if (global.end) return false;

		var screenHeight = document.body.clientHeight;
		var screenWidth = document.body.clientWidth;

		var randomX = Math.round(screenWidth/2 + Math.random() * screenWidth/3);
		var randomY = Math.round(Math.random() * screenHeight);

		enemies.push(api.obj()
				.create({
					x: randomX,
					y: randomY,
					life: 3,
					role: 'enemy',
					cls: 'enemy',
					power: 2,
					size: 20,
					speed: {
						dx: 0,
						dy: 0
					}
				}))
	}, 5000)

	setInterval(function() {

		if (global.end) return false;

		var screenHeight = document.body.clientHeight;
		var screenWidth = document.body.clientWidth;

		var randomY = Math.round (Math.random() * screenHeight);
		var randomYdeviation = Math.round(Math.random()*2 - 1);
		global.shots.push(api.obj()
						.create({
							x: screenWidth + 50,
							y: randomY,
							life: 1,
							role: 'asteroid',
							cls: 'asteroid',
							power: 2,
							size: 30,
							speed: {
								dx: -2,
								dy: randomYdeviation
							}
						}))
	}, 3500)

	var timeCount = function timeCount() {

		if (!global.totalTime) {
			global.end = true;
			delete global.objects;
			global.winner.style.display = 'block';
			global.body.style.display = 'none';
			return false;
		}

		global.time.innerHTML = global.totalTime;
		global.totalTime--;

		setTimeout(function() {
			timeCount();
		}, 1000)
	}()


})